const  
	Vue        = require('./init/Vue'),
	jquery     = require('jquery');

// Enable debugging to show plugin loading in the console output
Vue.config.debug = true

var root = new Vue({  
	ready: function (argument) {
		console.log("app is ready")
	},

	// element
	el: "#app",
	// data
	data: {
		cordova: Vue.cordova,
		partialID: 'splash',
		settings: {
			group: null
		},
		quizData: [],
		tipsData: [],
		groupData: {}
	},
	watch: {
		'settings.group': function (newValue, oldValue) {
			console.log('- app.js: watch: settings.group', newValue);
			this.loadGroupData(newValue);
		}
	},
	// methods
	methods: {
		gotoPage: function (page) {
			this.partialID = page || 'start';
		},
		loadTipsData: function () {
			jquery.getJSON('statics/data/tips.json')
				.then(function (data) {
					console.log('- app.js: loadTipsData', data);
					this.tipsData = data;
					return data;
				}.bind(this))
				.catch(function (error) {
					console.error(error);
				});
		},
		loadGroupData: function (i) {
			// return empty array
			if (Number.isNaN(Number(i))) { return [] };

			if(i == 1) {
				return jquery.getJSON('statics/data/groep1.json')
					.then(function (dataGroep1) {
						return jquery.getJSON('statics/data/groep3.json')
							.then(function(dataGroep3) {
								var quiz = dataGroep1.quiz;
								console.log('- quiz: groep1 |', quiz.length);
								quiz.push.apply(quiz, dataGroep3.quiz);
								console.log('- quiz: groep1 + groep3 |', quiz.length);
								return {
									"title": "14 of 15",
									"quiz": quiz
								};
							});
					})
					.then(function (data) {
						this.groupData = data;
						return data;
					}.bind(this))
					.catch(function (error) {
						console.error(error);
					});
			} else {
				// retrieve .json file
				return jquery.getJSON('statics/data/groep'+(parseInt(i)+1)+'.json')
					.then(function (data) {
						console.log('- app.js: loadGroupData', data);
						this.groupData = data;
						return data;
					}.bind(this))
					.then(function (data) {
						// check if there are minimal 10 questions
						// in 'quiz'
						// if not throw error
						try {
							var quizLength = data.quiz.length;
							if(!(quizLength >= 10)) {
								throw "Quiz length needs minimal 10 questions"
							}
						} catch(e) {
							throw "groupX.json got bad format: " + e;
						}
					})
					.catch(function (error) {
						console.error(error);
					});

			}
		},
		loadGroupJSON: function (file) {
			return jquery.getJSON('statics/data/groep'+(parseInt(i)+1)+'.json')
		},
		reloadGroupData: function () {
			var i = this.settings.group;
			return this.loadGroupData(i);
		}
	},
	// computed
	// computed can't pass value in HTML
	computed: {

	},
	filter: {
		cloned: function (data) {
			return JSON.parse(JSON.stringify(data));
		}
	},
	ready: function () {
		console.log('- app.js: ready');
		this.loadTipsData();
		this.reloadGroupData();
	}
});

module.exports = root; 