/* COMPONENT: duo */
var _ = require('lodash'),
	uuid = require('node-uuid'),
	$ = require('jquery'),
	animate = require('gsap-promise');


var component = {  
	template: require('./duo.html'),
	props: [
		'tipsData',
		'groupData',
		'gotoPage',
		'reloadGroupData'
	],
	partials: {
		'duo-intro':                     require('./duo-intro.html'),
		'duo-intro-content':             require('./duo-intro-content.html'),
		'duo-question':                  require('./duo-question.html'),
		'duo-question-content':          require('./duo-question-content.html'),
		'duo-answer':                    require('./duo-answer.html'),
		'duo-answer-overlay':            require('./duo-answer-overlay.html'),
		'duo-converse':                  require('./duo-converse.html'),
		'duo-converse-content':          require('./duo-converse-content.html'),
		'duo-tip-overlay':               require('./duo-tip-overlay.html'),
		'duo-finalscore-commonanswers':  require('./duo-finalscore-commonanswers.html'),
		'duo-finalscore-scorepoints':    require('./duo-finalscore-scorepoints.html'),
		'duo-finalscore-winner':         require('./duo-finalscore-winner.html'),
		'duo-finalscore-tips-overlay':   require('./duo-finalscore-tips-overlay.html'),
		'duo-overlay':                   require('./duo-overlay.html')
	},
	components: {
		'duo-answer-content': {
			components: {
				'duo-answer-label-radio': {
					template: require('./duo-answer-label-radio.html'),
					props: [
						'user',
						'option',
						'answer',
						'on-answer'
					]
				}
			},
			template: require('./duo-answer-content.html'),
			props: [
				'user',
				'options',
				'answer',
				'on-answer'
			]
		},

		'duo-timer-progress-bar': {
			template: require('./duo-timer-progress-bar.html'),
			props: [
				'percent'
			]
		},

		'duo-converse-answer-overlay': {
			template: require('./duo-converse-answer-overlay.html'),
			props: [
				'title',
				'which-overlay',
				'close-btn',
				'question',
				'answer'
			]
		}
	},
	data: function () {
		return {
			partialID: 'duo-intro',
			questionIndex: 0,
			questionTotal: 10,
			quiz: [],
			score: [
				{ me: 0, you: 0 }
			],
			checked: { me: false, you: false },
			answer: { me: null, you: null },
			overlay: {
				show: false,
				is_agree: false,
				is_timesup: false
			},
			agree_count: 0,
			timer: {
				setMaxTime: 20e3, // 20000 milliseconds -- editable
				active: null, // cFlag
				startTime: new Date(),
				timeDiff: null,
				percent: 0,
				timeoutID: null
			},
			timeoutID_overlay: null,
			converse_overlay: { me: false, you: false }
		}
	},
	watch: {
		'answer.me': function (newValue, oldValue) {
			console.log('- index.js duo - watch: answer.me |', newValue);
		},
		'answer.you': function (newValue, oldValue) {
			console.log('- index.js duo - watch: answer.you |', newValue);
		},
		'partialID': function (newValue, oldValue) {
		}
	},
	methods: {
		start: function () {
			this.gotoQuestion();
		},
		gotoIntro: function () {
			this.partialID = 'duo-intro';
		},
		gotoQuestion: function () {
			this.partialID   = 'duo-question';
			this.answer      = { me: null, you: null };
			clearTimeout(this.timeoutID_overlay);

			// render delay
			setTimeout(function() {
				Promise.all([
					animate.set('.duo-question-content, [gsap="fromBottom"], [gsap="fromTop"]', {
						opacity: 0
					}),
					animate.to('.duo-question-content', .4, {
						y: "0%",
						opacity: 1,
						ease: Expo.easeOut
					}),
					animate.to('[gsap="fromBottom"]', .2, {
						y: 0,
						opacity: 1,
						ease: Expo.easeOut,
						delay: .4
					}),
					animate.to('[gsap="fromTop"]', .4, {
						y: 0,
						opacity: 1,
						ease: Bounce.easeOut,
						delay: .8
					})

				]).then(function() {
				}.bind(this))
				
			}.bind(this), 0);
		},
		gotoAnswer: function () {
			this.partialID = 'duo-answer';
			console.log('- gotoAnswer');
			// render delay
			setTimeout(function() {
				Promise.all([
					animate.set('.duo-timer-progress-bar, .duo-answer-option, .duo-answer-label, .row:nth-child(2)', {
						opacity: 0
					}),
					animate.set('.row:nth-child(1)', {
						'border-top-width': 0
					}),
					animate.to('.row:nth-child(1)', .2, {
						'border-top-width': 4,
						ease: Expo.easeOut
					}),
					animate.to('.duo-timer-progress-bar', 1, {
						opacity: 1,
						delay: .2
					}),
					animate.set('.duo-timer-progress-bar-percent', {
						width: "0%"
					}),
					// animate.to('.duo-timer-progress-bar-percent', 1, {
					// 	width: "0%",
					// 	delay: .2
					// }),
					animate.to('.duo-answer-label, .row:nth-child(2)', 1, {
						opacity: 1,
						ease: Expo.easeOut,
						delay: .2
					}),
					animate.set('.duo-answer-option', {
						y: -30
					}),
					animate.to('.row:nth-child(1) .duo-answer-label:nth-child(1) .duo-answer-option', .4, {
						y: 0,
						opacity: 1,
						ease: Expo.easeOut,
						delay: .6
					}),
					animate.to('.row:nth-child(1) .duo-answer-label:nth-child(2) .duo-answer-option', .4, {
						y: 0,
						opacity: 1,
						ease: Expo.easeOut,
						delay: .8
					}),
					animate.to('.row:nth-child(2) .duo-answer-label:nth-child(1) .duo-answer-option', .4, {
						y: 0,
						opacity: 1,
						ease: Expo.easeOut,
						delay: 1
					}),
					animate.to('.row:nth-child(2) .duo-answer-label:nth-child(2) .duo-answer-option', .4, {
						y: 0,
						opacity: 1,
						ease: Expo.easeOut,
						delay: 1.2
					}),
				]).then(function() {
					// this.startTimer();
				}.bind(this))
				
			}.bind(this), 0);
		},
		gotoConverse: function () {
			this.partialID = 'duo-converse';
			clearTimeout(this.timeoutID_overlay);

			// render delay
			setTimeout(function() {
				Promise.all([
					animate.set('.me-btn, .you-btn, .duo-converse-content-article', {
						opacity: 0
					}),
					animate.set('.duo-tip-button, .me-btn, .you-btn', {
						y: -30
					}),
					animate.set('.duo-converse-content-article', {
						y: 30
					}),
					animate.to('.duo-tip-button, .me-btn, .you-btn', .3, {
						y: 0,
						opacity: 1,
						ease: Expo.easeOut
					}),
					animate.to('.duo-converse-content-article', .6, {
						y:0,
						opacity: 1,
						ease: Expo.easeOut,
						delay: .2
					})

				]).then(function() {
				}.bind(this))
				
			}.bind(this), 0);
		},
		gotoFinalscoreCommonanswers: function () {
			this.partialID = 'duo-finalscore-commonanswers';

			// render delay
			setTimeout(function() {
				Promise.all([
					animate.set('.me-btn, .you-btn, article', {
						opacity: 0
					}),
					animate.set('article', {
						y: 30
					}),
					animate.set('.me-btn, .you-btn', {
						y: -30
					}),
					animate.to('.me-btn, .you-btn', .4, {
						y: 0,
						opacity: 1,
						ease: Expo.easeOut
					}),
					animate.to('article', .6, {
						y: 0,
						opacity: 1,
						ease: Elastic.easeOut,
						delay: .2
					})

				]).then(function() {
				}.bind(this))
				
			}.bind(this), 0);

		},
		gotoFinalscoreScorepoints: function () {
			this.partialID = 'duo-finalscore-scorepoints';

			// render delay
			setTimeout(function() {
				Promise.all([
					animate.set('h2', {
						opacity: 0,
						y: 30
					}),
					animate.to('h2:nth-child(1)', .4, {
						opacity: 1,
						y: 0,
						ease: Elastic.easeOut
					}),
					animate.to('h2:nth-child(2)', .4, {
						opacity: 1,
						y: 0,
						ease: Elastic.easeOut,
						delay: .2
					}),
				]).then(function() {
				}.bind(this))
				
			}.bind(this), 0);

		},
		gotoFinalscoreWinner: function () {
			this.partialID = 'duo-finalscore-winner';

			// render delay
			setTimeout(function() {
				Promise.all([
					animate.set('article, [gsap="easeFromTop"], [gsap="easeFromBottom"]', {
						opacity: 0
					}),
					animate.set('article, [gsap="easeFromBottom"]', {
						y: 30
					}),
					animate.set('[gsap="easeFromTop"]', {
						y: -30
					}),
					animate.to('[gsap="easeFromTop"]', .2, {
						opacity: 1,
						y: 0,
						ease: Expo.easeOut
					}),
					animate.staggerTo('[gsap="easeFromBottom"]', .2, {
						opacity: 1,
						y: 0,
						ease: Expo.easeOut,
						delay: .2
					}),
					animate.to('article', 1, {
						opacity: 1,
						y: 0,
						ease: Elastic.easeOut,
						delay: .6
					})
				]).then(function() {
				}.bind(this))
				
			}.bind(this), 0);
		},
		onChecked: function (who) {
			console.log('- index.js duo - onChecked', who);
			if(who == 'me' && !this.checked.me) {
				this.$set('checked.me', true);
				Promise.all([
					animate.from('.me-btn', .3, {
						scale: .1,
						opacity: 0,
						ease: Elastic.easeOut
					})
				]).then(function() {
					// console.log('- start/index.js |', "all animations finished")
					this.onBothChecked();
				}.bind(this))
			}
			if(who == 'you' && !this.checked.you) {
				this.$set('checked.you', true);
				Promise.all([
					animate.from('.you-btn', .3, {
						scale: .1,
						opacity: 0,
						ease: Elastic.easeOut
					})
				]).then(function() {
					// console.log('- start/index.js |', "all animations finished")
					this.onBothChecked();
				}.bind(this))
			}

		},
		onBothChecked: function () {
			if(this.checked.me && this.checked.you) {
				console.log('- duo index.js - onChecked (true,true)')
				this.resetChecked();

				switch(this.partialID) {
					case 'duo-intro':
						Promise.all([
							animate.to('.duo-intro-content h1, .duo-intro-content p', .4, {
								opacity: 0,
								ease: Expo.easeOut
							})
						]).then(function() {
							this.gotoQuestion();
						}.bind(this))
						break;
					case 'duo-question':
						Promise.all([
							animate.to('.me-btn, .you-btn, .close-btn', 1, {
								opacity: 0,
								ease: Expo.easeOut
							}),
							animate.to('[gsap="fromTop"], [gsap="fromBottom"]', .2, {
								opacity: 0,
								ease: Expo.easeOut
							}),
							animate.to('.duo-question-content', .2, {
								marginTop: 0,
								ease: Expo.easeOut,
								delay: .2
							}),
							animate.set('.duo-question-content', {
								'border-top': "solid 0px #000"
							}),
							animate.to('.duo-question-content', .2, {
								'border-top-width': 10,
								ease: Expo.easeOut,
								delay: .4
							}),
							animate.to('.duo-question-content', .4, {
								'border-top-width': 0,
								ease: Bounce.easeOut,
								delay: .6
							}),
						]).then(function() {
							this.gotoAnswer();
						}.bind(this))
						break;
					case 'duo-answer':
						// if both answer aren't same-same
						this.gotoConverse();
						// if both answer are the same
						// goto next question
						this.nextQuestion();
						break;
					case 'duo-converse':
						Promise.all([
							animate.to('.duo-tip-button, .me-btn, .you-btn', .2, {
								opacity: 0,
								ease: Expo.easeIn
							}),
							animate.to('.duo-converse-content-article', .4, {
								opacity: 0,
								y: 30,
								ease: Expo.easeIn,
								delay: .2
							})
						]).then(function() {
							this.nextQuestion();
						}.bind(this))
						break;
					case 'duo-finalscore-commonanswers':
						Promise.all([
							animate.to('article h2', .2, {
								opacity: 0
							})
						]).then(function() {
							this.gotoFinalscoreScorepoints();
						}.bind(this))
						break;
					case 'duo-finalscore-scorepoints':
						this.gotoFinalscoreWinner();
						break;
					default:
						this.resetChecked();
				}
			}
		},
		onAnswer: function (who, value) {

			if(!this.answer[who]) {
				console.log('- onAnswer - set', who);
				this.$set('answer.'+who, value);
				this.addUserPointFromUuid(who, value);
			}
			console.log('- index.js duo - onAnswer |', who, value);
			// console.log(this.$els['myAnswer']);
			var elements = $(this.$els[who+'Answer']).find('input[name="'+who+'"]');
			// console.log('- index.js duo - onAnswer : $', elements);
			_(elements).forEach(function (item) {
				// console.log('- onAnswer |', item);
				$(item).attr("disabled", "disabled");
				item.disabled = true;
			});

			if(this.answer.me && this.answer.you) {
				console.log('- index.js - onAnswer: BOTH answered? ')
				this.overlay.show = true;
				this.overlay.is_agree = (this.answer.me === this.answer.you);
				var i = Number(this.agree_count);
				i += Number(this.answer.me === this.answer.you);
				this.agree_count = i;

				clearTimeout(this.timeoutID_overlay);
				if(!(this.answer.me === this.answer.you)) {

					this.timeoutID_overlay = setTimeout(function () {
						this.overlay.show = false;
						this.gotoConverse();
					}.bind(this), 1500);
				} else {
					this.timeoutID_overlay = setTimeout(function () {
						this.overlay.show = false;
						this.nextQuestion();
					}.bind(this), 1500);
				}
				// stop timer
				this.stopTimer();
			}
		},
		onToggleOverlay: function (attr, value) {
			console.log('- onToggleOverlay |', attr, value);
			this.$set(attr, value)
		},
		nextQuestion: function () {
			console.log('- index.js:solo nextQuestion');
			var i = this.questionIndex;
			++i;


			if(i > this.questionTotal-1) {
				// goto solo-end
				console.log('- index.js: duo nextQuestion - END');
				this.gotoFinalscoreCommonanswers();
				i = this.questionTotal-1;
				return;
			}

			this.questionIndex = i;
			this.gotoQuestion();
		},
		reset: function () {
			this.agree_count = 0;
			this.questionIndex = 0;
			this.score = [];
			this.getRandomTenQuestions();
			this.gotoIntro();
		},
		resetChecked: function () {
			this.$set('checked', { me: false, you: false });
		},
		resetOverlay: function(gotoCaller) {
			console.log('- index.js duo: resetOverlay');
			this.$set('overlay', {
				show: false,
				is_agree: false,
				is_timesup: false
			});
			this.resetChecked();

			gotoCaller();
		},
		random: function (value) {
			return Math.floor((Math.random() * value));
		},
		getRandomTenQuestions: function () {
			var randomGroupDataIndex = null;
			var randomQuiz = [];
			var i;

			console.log('- index.js solo: getRandomTenQuestions: clone data for splice events')
			// clone data for splice events
			var cloneGroupData = this.reConvertData(this.groupData).quiz;
			// console.log(JSON.stringify(cloneGroupData, null, 4));
			console.log('--------------')

			console.log('- index.js solo: getRandomTenQuestions: group into categories')
			// group into categories
			var categories = _.uniqBy(cloneGroupData, 'tip_id');
			console.log('- index.js solo: getRandomTenQuestions: select random max 10 categories');
			console.log('- categories |', categories);
			// console.log('- stringify |', JSON.stringify(categories, '####', 4))
			// select random max 10 categories
			var length = categories.length > 10 ? 10 : categories.length;
			var selectedCategories = [];
			var randomCategoryIndex = null;

			for (i = length - 1; i >= 0; i--) {
				randomCategoryIndex = this.random(categories.length);
				var splicedData = categories.splice(randomCategoryIndex, 1);
				selectedCategories.push(splicedData[0]);
			}
			selectedCategories = _.orderBy(selectedCategories, ['tip_id'], ['desc']);
			console.log('- selectedCategories |', JSON.stringify(selectedCategories, null, 4));

			console.log('- index.js solo: getRandomTenQuestions: iterate the selectedCategory')
			// iterate the selectedCategory
			for (i = selectedCategories.length - 1; i >= 0; i--) {
				var tip_id = selectedCategories[i].tip_id;

				console.log('- tip_id |', tip_id);

				// select random items from that category
				var itemsFromThatCategory = _.filter(cloneGroupData, { 'tip_id': tip_id });
				var randomFromThatCategoryIndex = this.random(itemsFromThatCategory.length);
				var questionItem = itemsFromThatCategory[randomFromThatCategoryIndex];
				questionItem.options = this.assignUuidOnEachOption(questionItem.options);
				questionItem.options = _.shuffle(questionItem.options);
				randomQuiz.push(questionItem);
			}

			this.quiz = randomQuiz;
			return randomQuiz;
			
		},
		getRandomTenQuestionsV1: function () {
			if(this.groupData.quiz == null) {
				console.error("GroupData is not yet loaded, must select group");
				this.reloadGroupData()
					.then(function () {
						this.getRandomTenQuestionsDebounce();
					}.bind(this));
				return;
			}
			
			console.log('- index.js duo - getRandomTenQuestions');
			// console.log(JSON.stringify(this.reConvertData(this.groupData)),null, 4);

			var cloneGroupData = this.reConvertData(this.groupData).quiz;
			var randomGroupDataIndex = null;
			var randomQuiz = [];
			for (var i = 10 - 1; i >= 0; i--) {
				randomGroupDataIndex = this.random(cloneGroupData.length);
				var splicedData = cloneGroupData.splice(randomGroupDataIndex, 1);
				splicedData[0].options = this.assignUuidOnEachOption(splicedData[0].options);
				randomQuiz.push(splicedData[0]);
			}
			this.quiz = randomQuiz;
			return randomQuiz;
		},
		getRandomTenQuestionsDebounce: function() {
			return _.debounce(this.getRandomTenQuestions, 500);
		},
		assignUuidOnEachOption: function(array) {
			for (var i = array.length - 1; i >= 0; i--) {
				array[i].uuid = uuid.v1();
			}
			return array;
		},
		shuffleTheFourAnswerOptions: function (array) {
			var cloneOptions = this.reConvertData(array);
			var shuffeledOptions = [];

			// shuffles the array position and push to new array
			do {
				shuffeledOptions.push(cloneOptions.splice(this.random(cloneOptions.length), 1)[0])
			} while(cloneOptions.length > 0);

			return shuffeledOptions;
		},
		reConvertData: function (data) {
			return JSON.parse(JSON.stringify(data));
		},
		showTip: function() {
			console.log('- index.js duo: showTip');
			this.overlay.show = true;
		},
		hideTip: function () {
			this.overlay.show = false;
		},
		addUserPointFromUuid: function (who, uuid) {
			console.log('- addUserPointFromUuid |', who, uuid);
			var options = this.quiz[this.questionIndex].options;
			var point = _.find(options, { uuid: uuid }).score;

			this.score[this.questionIndex] = Object.assign(this.score[this.questionIndex] || {}, {[who]: point});
		},

		timerPercent: function() {
			var now = new Date();
			var timeDiff = now.getTime() - this.timer.startTime.getTime();
			this.timer.timeDiff = timeDiff;
			var percent =  ((timeDiff/this.timer.setMaxTime)*100);
			if (percent <= 100) {
				this.timer.percent = percent;
				this.timer.timeoutID = setTimeout(this.timerPercent, 1);
			} else {
				console.log('- timerPercent: endTimer');
				this.onEndTimer();
			}
		},
		startTimer: function() {
			this.timer.startTime = new Date();
			this.timerPercent();
			this.timer.active = true;
		},
		stopTimer: function() {
			clearTimeout(this.timer.timeoutID);
		},
		toggleTimer: function() {

		},
		onEndTimer: function() {
			this.overlay.is_timesup = true;
			this.overlay.show = true;
		}
	},

	computed: {
		currentQuestion: function () {
			return this.questionIndex + 1;
		},
		totalQuestions: function () {
			return this.questionTotal;
		},
		myScore: function () {
			var length = this.score.length;
			var count = 0;
			for (var i = 0; i < length ; i++) {
				count += this.score[i] && this.score[i].me || Number(0);
			}
			return Number(count);
		},
		yourScore: function () {
			var length = this.score.length;
			var count = 0;
			for (var i = 0; i < length ; i++) {
				count += this.score[i] && this.score[i].you || Number(0);
			}
			return Number(count);
		},
		myAnswer: function () {
			var uuid = this.answer['me'];
			var options = this.quiz[this.questionIndex].options;
			var answer = _.find(options, { uuid: uuid }).option;
			return answer;
		},
		yourAnswer: function () {
			var uuid = this.answer['you'];
			var options = this.quiz[this.questionIndex].options;
			var answer = _.find(options, { uuid: uuid }).option;
			return answer;
		},
		getTipById: function () {
			var tip_id = this.quiz[this.questionIndex].tip_id;
			console.log('- index.js duo: getTipById |', tip_id);
			console.log('- index.js duo: tipsData |', this.tipsData);
			var item = _.find(this.reConvertData(this.tipsData), {'id': tip_id});
			if(item) {
				return {
					title: item.title,
					description: item.description
				}

			} else {
				return {
					title: 'No tips',
					description: 'Tips data is not loaded yet.'
				}
			}
		}
	},
	filters: {
		shuffle: function (array) {
			return this.shuffleTheFourAnswerOptions(array)
		}
	},
	attached: function () {
		console.log('- index.js duo - attached');
		this.getRandomTenQuestions();
	},
	ready: function () {
		console.log('- index.js duo: ready');
	}
}
module.exports = component;