var animate = require('gsap-promise');

var component = {
	template: require('./settings.html'),
	props: [
		'settings',
		'goto-page'
	],
	data: function () {
		return {
			checked: null
		}
	},
	methods: {
		saveGroup: function () {
			console.log('- onboarding/index.js : saveGroup |')
			console.log('- # saved database and go START')
			this.checked = true;
			Promise.all([
				animate.from('.me-btn', .3, {
						scale: .1,
						opacity: 0,
						ease: Elastic.easeOut
				}),
				animate.staggerTo('.label-radio', 1, {
					y: -100,
					opacity: 0,
					ease: Expo.easeIn
				}, .2)
			]).then(function() {
				this.gotoPage('start');
			}.bind(this))
		}
	},
	ready: function () {
		Promise.all([
			animate.staggerFrom('.label-radio', 1, {
				y: 25,
				opacity: 0,
				ease: Elastic.easeOut
			}, .2)
		]).then(function() {
		}.bind(this))

		this.checked = null;
	}
}
module.exports = component;  