/* COMPONENT: solo */
var _    = require('lodash'),
	uuid = require('node-uuid'),
	animate = require('gsap-promise'),
	$       = require('jquery');

var component = {
	partials: {
		'solo-intro':      require('./solo-intro.html'),
		'solo-question':   require('./solo-question.html'),
		'solo-answer':     require('./solo-answer.html'),
		'solo-feedback':   require('./solo-feedback.html'),
		'solo-finalscore': require('./solo-finalscore.html'),
		'solo-info':       require('./solo-info.html'),
		'solo-contact':    require('./solo-contact.html')
	},
	components: {
		'solo-answer-label-radio': {
			template: require('./solo-answer-label-radio.html'),
			props: [
				'answer',
				'option',
				'on-answer',
				'index'
			]
		},
		'meerweten': { template: require('../../../../statics/data/meerweten.md') },
		'directhulp': { template: require('../../../../statics/data/directhulp.md') }
	},
	template: require('./solo.html'),
	props: [
		'tipsData',
		'groupData',
		'gotoPage',
		'reloadGroupData'
	],
	data: function () {
		return {
			partialID: 'solo-intro',
			questionIndex: 0,
			questionTotal: 10,
			quiz: [],
			score: [
				{ me: 0 }
			],
			answer: null,
			point: null,
			myAnswer: {},
			checked: null,
			media_url: 'http://techslides.com/demos/sample-videos/small.mp4'
		}
	},
	methods: {
		start: function () {
			this.gotoQuestion();
		},
		gotoIntro: function () {
			this.partialID = 'solo-intro';
		},
		gotoQuestion: function () {
			this.partialID = 'solo-question';
			console.log('- gotoQuestion');

			// render delay
			setTimeout(function() {
				Promise.all([
					animate.set('[gsap="fromBottom"]', {
						y: 30,
						opacity: 0
					}),
					animate.staggerTo('[gsap="fromBottom"]', 1, {
						y: 0,
						opacity: 1,
						ease: Expo.easeOut
					}, .2),
					animate.to('.solo-question-main-header-overlay', .6, {
						opacity: 0,
						ease: Expo.easeIn,
						delay: .2
					})
				]).then(function() {
				}.bind(this))
				
			}.bind(this), 0);
		},
		gotoAnswer: function () {
			this.answer = null;
			this.partialID = 'solo-answer';

			// render delay
			setTimeout(function() {
				Promise.all([
					animate.to('.solo-answer-label, .row:nth-child(2)', .2, {
						opacity: 1,
						ease: Expo.easeIn
					}),
					animate.staggerTo('.solo-answer-option', .4, {
						y: 0,
						opacity: 1,
						ease: Expo.easeOut
					}, 0.2)
				]).then(function() {
				}.bind(this))
				
			}.bind(this), 0);
		},
		gotoFeedback: function () {
			this.partialID = 'solo-feedback';

			// render delay
			setTimeout(function() {
				Promise.all([
					animate.set('article, .solo-feedback-main-score, .solo-feedback-main-pickedanswer', {
						opacity: 0
					}),
					animate.set('.solo-feedback-main-pickedanswer', {
						y: -30
					}),
					animate.set('article', {
						y: 30
					}),
					animate.to('.solo-feedback-main-score', .5, {
						opacity: 1,
						ease: Expo.easeIn
					}),
					animate.to('.solo-feedback-main-pickedanswer', .5, {
						y: 0,
						opacity: 1,
						ease: Expo.easeOut
					}, 0.2),
					animate.staggerTo('article', 2, {
						y: 0,
						opacity: 1,
						ease: Elastic.easeOut
					}, 0.2)
				]).then(function() {
				}.bind(this))
				
			}.bind(this), 0);
		},
		gotoFinalscore: function () {
			this.partialID = 'solo-finalscore';

			// render delay
			setTimeout(function() {
				Promise.all([
					animate.set('.solo-finalscore-article, [gsap="easeFromBottom"],[gsap="easeFromTop"]', {
						opacity: 0
					}),
					animate.set('.solo-finalscore-article, [gsap="easeFromBottom"]', {
						y: 30
					}),
					animate.set('[gsap="easeFromTop"]', {
						y: -30
					}),
					animate.to('.solo-finalscore-article', 1, {
						y: 0,
						opacity: 1,
						ease: Elastic.easeOut,
						delay: .6
					}),
					animate.staggerTo('[gsap="easeFromBottom"]', .6, {
						y: 0,
						opacity: 1,
						ease: Expo.easeOut
					}, .2),
					animate.staggerTo('[gsap="easeFromTop"]', .6, {
						y: 0,
						opacity: 1,
						ease: Expo.easeOut,
						delay: .4
					}, .2)
				]).then(function() {
				}.bind(this))
				
			}.bind(this), 0);
		},
		gotoInfo: function () {
			this.partialID = 'solo-info';
		},
		gotoContact: function () {
			this.partialID = 'solo-contact';
		},
		onTap: function (event, callee) {
			var target = event.target;
			$(target).addClass('active');
			Promise.all([
				animate.from(target, .3, {
					scale: .5,
					opacity: 0,
					ease: Elastic.easeOut
				})
			]).then(function() {
				callee();
			}.bind(this))
		},
		onChecked: function (callee) {
			this.checked = true;
			Promise.all([
				animate.from('.me-btn', .3, {
					scale: .1,
					opacity: 0,
					ease: Elastic.easeOut
				})
			])
			.then(function() {
				switch(this.partialID) {
					case 'solo-question':
						return animate.staggerTo('[gsap="fromBottom"]', .2, {
							y: 30,
							opacity: 0,
							ease: Expo.easeIn
						}, .2)
						break;
				}
			}.bind(this))
			.then(function() {
				callee();
				this.checked = false;
			}.bind(this))
		},
		onAnswer: function (option_uuid) {
			// body...
		},
		addUserPointFromUuid: function (who, uuid) {
			console.log('- addUserPointFromUuid |', who, uuid);
			var options = this.quiz[this.questionIndex].options;
			var object = _.find(options, { uuid: uuid });
			var point = object.score;
			this.myAnswer = object;
			this.point = point;
			// this.score[this.questionIndex] = Object.assign(this.score[this.questionIndex] || {}, {[who]: point});
			this.score.push({me: point});
		},
		gotoFeedBackWithMyAnswer: function (uuid) {
			if(!this.answer) {
				this.addUserPointFromUuid('me', uuid);
				this.answer = uuid;
			
				setTimeout(this.gotoFeedback, 300);
				
			} else {
				console.error('- gotoFeedBackWithMyAnswer: this.answer already got value')
			}
		},
		shareWhatsapp: function (event) {

			console.log('- index.js: solo - shareWhatsapp |');
			var text = "Download ‘ik zie je’, de app die je leert wat je kan doen voor mensen met een depressie, via [link App Store] of [link Play Store]";
			var uriEncoded = $.param({text});
			var fullHref = "whatsapp://send?"+uriEncoded;
			console.log(fullHref);
			window.open(fullHref);
			window.location = fullHref;
		},
		nextQuestion: function () {
			console.log('- index.js:solo nextQuestion');
			var i = this.questionIndex;
			++i;


			if(i > this.questionTotal-1) {
				// goto solo-end
				console.log('- index.js: solo nextQuestion - END');
				this.gotoFinalscore();
				i = this.questionTotal-1;
				return;
			}

			this.questionIndex = i;
			this.gotoQuestion();
		},
		reset: function () {
			this.questionIndex = 0;
			this.score = [];
			this.getRandomTenQuestions();
			this.gotoIntro();
		},
		random: function (value) {
			return Math.floor((Math.random() * value));
		},
		getRandomTenQuestions: function () {
			var randomGroupDataIndex = null;
			var randomQuiz = [];
			var i;

			console.log('- index.js solo: getRandomTenQuestions: clone data for splice events')
			// clone data for splice events
			var cloneGroupData = this.reConvertData(this.groupData).quiz;
			// console.log(JSON.stringify(cloneGroupData, null, 4));
			console.log('--------------')

			console.log('- index.js solo: getRandomTenQuestions: group into categories')
			// group into categories
			var categories = _.uniqBy(cloneGroupData, 'tip_id');
			console.log('- index.js solo: getRandomTenQuestions: select random max 10 categories');
			console.log('- categories |', categories);
			// console.log('- stringify |', JSON.stringify(categories, '####', 4))
			// select random max 10 categories
			var length = categories.length > 10 ? 10 : categories.length;
			var selectedCategories = [];
			var randomCategoryIndex = null;

			for (i = length - 1; i >= 0; i--) {
				randomCategoryIndex = this.random(categories.length);
				var splicedData = categories.splice(randomCategoryIndex, 1);
				selectedCategories.push(splicedData[0]);
			}
			selectedCategories = _.orderBy(selectedCategories, ['tip_id'], ['desc']);

			this.questionTotal = selectedCategories.length;
			console.log('- selectedCategories |', JSON.stringify(selectedCategories, null, 4));

			console.log('- index.js solo: getRandomTenQuestions: iterate the selectedCategory')
			// iterate the selectedCategory
			for (i = selectedCategories.length - 1; i >= 0; i--) {
				var tip_id = selectedCategories[i].tip_id;

				console.log('- tip_id |', tip_id);

				// select random items from that category
				var itemsFromThatCategory = _.filter(cloneGroupData, { 'tip_id': tip_id });
				var randomFromThatCategoryIndex = this.random(itemsFromThatCategory.length);
				var questionItem = itemsFromThatCategory[randomFromThatCategoryIndex];

				questionItem.options = this.assignUuidOnEachOption(questionItem.options);
				questionItem.options = _.shuffle(questionItem.options);
				randomQuiz.push(questionItem);
			}

			this.quiz = randomQuiz;
			return randomQuiz;
			
		},
		getRandomTenQuestionsV1: function () {
			if(this.groupData.quiz == null) {
				console.error("GroupData is not yet loaded, must select group");
				this.reloadGroupData()
					.then(function () {
						// this.getRandomTenQuestions();
					}.bind(this));
				return;
			}
			
			console.log('- index.js solo - getRandomTenQuestions');
			// console.log(JSON.stringify(this.reConvertData(this.groupData)),null, 4);

			var cloneGroupData = this.reConvertData(this.groupData).quiz;
			var randomGroupDataIndex = null;
			var randomQuiz = [];
			for (var i = 10 - 1; i >= 0; i--) {
				randomGroupDataIndex = this.random(cloneGroupData.length);
				var splicedData = cloneGroupData.splice(randomGroupDataIndex, 1);
				splicedData[0].options = this.shuffleTheFourAnswerOptions(splicedData[0].options);
				randomQuiz.push(splicedData[0]);
			}
			this.quiz = randomQuiz;
			return randomQuiz;
		},
		assignUuidOnEachOption: function(array) {
			for (var i = array.length - 1; i >= 0; i--) {
				array[i].uuid = uuid.v1();
			}
			return array;
		},
		shuffleTheFourAnswerOptions: function (array) {
			var cloneOptions = this.reConvertData(array);
			var shuffeledOptions = [];

			// shuffles the array position and push to new array
			do {
				shuffeledOptions.push(cloneOptions.splice(this.random(cloneOptions.length), 1)[0])
			} while(cloneOptions.length > 0);

			return shuffeledOptions;
		},
		reConvertData: function (data) {
			return JSON.parse(JSON.stringify(data));
		}
	},

	computed: {
		currentQuestion: function () {
			return this.questionIndex + 1;
		},
		totalQuestions: function () {
			return this.questionTotal;
		},
		myScore: function () {
			var length = this.score.length;
			var count = 0;
			for (var i = 0; i < length ; i++) {
				count += this.score[i] && this.score[i].me || Number(0)
			}
			return Number(count);
		},
		getOtherGoodOptions: function () {
			var options = this.reConvertData(this.quiz[this.questionIndex].options);
			var goodOptions = _.filter(options, function (item) {
				return (item.score > 0)
			});
			var myAnswer = this.reConvertData(this.myAnswer)
			var differenceOptions = _.filter(goodOptions, function (item) {
				return item.option != myAnswer.option
			})
			return differenceOptions;
		}
	},
	attached: function () {
		console.log('- index.js solo - attached');
		this.checked = null;
		this.getRandomTenQuestions();
	},
	ready: function () {
		console.log('- index.js solo: ready');
	}
}
module.exports = component;  