var animate = require('gsap-promise');

var component = {
    template: require('./splash.html'),
    props: [
    	'goto-page',
    ],
    data: {
        timeoutID: null,
        skipped: false
    },
    methods: {
        onSkip: function() {
            clearTimeout(this.timeoutID);
            if(!this.skipped) {
                this.skipped = true;
                this.fadeOut();
            }
        },
        fadeOut: function() {
            Promise.all([
                animate.staggerTo('.splash[gsap="fadeOut"]', 1, {
                    opacity: 0,
                    ease: Expo.easeIn
                }, .2)
            ]).then(function() {
                this.gotoPage('onboarding')
            }.bind(this))
        }
    },
    compiled: function () {
        clearTimeout(this.timeoutID);
        this.skipped = false;
        this.timeoutID = setTimeout(function() {
        	this.fadeOut();
        }.bind(this), 10000);
    }
}
module.exports = component;
