// routes.js

var _ = require('lodash');

module.exports = function (crossroads, vue_app) {

	crossroads.addRoute(':rest*:', function(){
		this.partialID = '404';
	}.bind(vue_app), -Infinity);
	
	crossroads.addRoute('/', function(){
		this.partialID = 'splash';
	}.bind(vue_app));

	crossroads.addRoute('/splash', function(){
		this.partialID = 'splash';
	}.bind(vue_app));

	crossroads.addRoute('/onboarding', function(){
		this.partialID = 'onboarding';
	}.bind(vue_app));

	crossroads.addRoute('/start', function(){
		this.partialID = 'start';
	}.bind(vue_app));

	crossroads.addRoute('/settings', function(){
		this.partialID = 'settings';
	}.bind(vue_app));
	
	crossroads.addRoute('/contact', function(){
		this.partialID = 'contact';
	}.bind(vue_app));

	crossroads.addRoute('/info', function(){
		this.partialID = 'info';
	}.bind(vue_app));

	crossroads.addRoute('/solo', function(){
		this.partialID = 'solo';
	}.bind(vue_app));

	crossroads.addRoute('/solo/intro', function(){
		this.partialID = 'solo';
	}.bind(vue_app));

	crossroads.addRoute('/solo/{id}/{page}', function(id, page){
		this.partialID = 'solo';
		console.log('- routes.js: solo/'+id+'/'+page);
		var comp = this.$refs.solo.partialID;
		console.log('- routes.js: comp', comp);
	}.bind(vue_app));

	crossroads.addRoute('/duo', function(){
		this.partialID = 'duo';
	}.bind(vue_app));


	crossroads.routed.add(console.log, console); //log all routes

	return crossroads;
}